<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    D3 Data Development
 * @copyright 2016 D3 Data Development
 * @license   LICENSE.txt
 */

include(_PS_MODULE_DIR_ . '/heidelpay/libraries/vendor/autoload.php');
include_once(_PS_MODULE_DIR_ . '/heidelpay/models/HeidelpayTransactionModel.php');

/**
 * Class HeidelpayModuleFrontController
 */
class HeidelpayModuleFrontController extends ModuleFrontController
{
    public $ssl = true;
    public $display_column_left = false;
    public $display_column_right = false;
    public $currentTemplate = 'hpf.tpl';

    const BLOFISH_KEY = 'BJGNGVEI6D78G68DFG8D74FG6DFGDGFGDFG654A6YXZTZ';
    const BLOFISH_VALUE = 'D6GF4GD466D48ER69R6ZIU4ZK46X6FV4G6ASF4H74GH8T';

    public function initHeader()
    {
        parent::initHeader();

        $this->setTemplate($this->currentTemplate);
        $this->context->smarty->assign(array('error_tpl' => "", 'hideOrderSteps' => false));
    }

    public function initContent()
    {
        parent::initContent();
        $cart = $this->context->cart;
        if ($cart->nbProducts() <= 0) {
            $translation  = $this->module->l('Your shopping cart is empty');
            $this->errors = array($translation);
            $this->setTemplate("error.tpl");
        }
    }

    public function getHeidelpayUrl()
    {
        if (Configuration::get('HEIDELPAY_LIVE_MODE')) {
            return 'https://heidelpay.hpcgw.net/ngw/post';
        }

        return 'https://test-heidelpay.hpcgw.net/ngw/post';
    }

    public function getHeidelpayCurlTimeOut()
    {
        return 30;
    }

    public function getHeidelpayNgwBrands($response)
    {
        $sConfig_brands = $response['CONFIG_BRANDS'];
        if (get_magic_quotes_gpc()) {
            $sConfig_brands = Tools::stripslashes($sConfig_brands);
        }

        return Tools::jsonDecode($sConfig_brands, true);
    }

    public function encode($parameter)
    {
        return Tools::jsonEncode($parameter);
    }

    public function decode($parameter)
    {
        return Tools::jsonDecode($parameter, true);
    }

    public function generateHash($data)
    {
        $stringToHash = Configuration::get('HEIDELPAY_SECRET', null);
        $stringToHash .= $data['CRITERION.SESSION'];
        $stringToHash .= $data['IDENTIFICATION.TRANSACTIONID'];
        $stringToHash .= $data['PRESENTATION.AMOUNT'];
        $stringToHash .= $data['PRESENTATION.CURRENCY'];
        $stringToHash .= $data['TRANSACTION.CHANNEL'];
        $ascii = bin2hex($stringToHash);

        $hash = sha1($ascii);

        PrestaShopLogger::addLog(
            __CLASS__ . '::hash:' . $hash . '::stringToHash:' . $stringToHash,
            1,
            null,
            'Heidelpay Module',
            null,
            true
        );

        return $hash;
    }

    public function isHashValid($response)
    {
        $sOriginalHash = $response['CRITERION_HASH'];

        $stringToHash = Configuration::get('HEIDELPAY_SECRET', null);
        $stringToHash .= $response['CRITERION_SESSION'];
        $stringToHash .= $response['IDENTIFICATION_TRANSACTIONID'];
        $stringToHash .= $response['PRESENTATION_AMOUNT'];
        $stringToHash .= $response['PRESENTATION_CURRENCY'];
        $stringToHash .= $response['TRANSACTION_CHANNEL'];
        $ascii      = bin2hex($stringToHash);
        $sCheckHash = sha1($ascii);


        PrestaShopLogger::addLog(
            __CLASS__ . '::stringToHash:' . $stringToHash . //
            '::sCheckHash:' . $sCheckHash . '::$sOriginalHash:' . $sOriginalHash,
            1,
            null,
            'Heidelpay Module',
            null,
            true
        );

        return $sCheckHash === $sOriginalHash;
    }

    public function validateCustomerData(array $formularParameters)
    {
        $mandatoryFields = array(
            'NAME.GIVEN',
            'NAME.FAMILY',
            'ADDRESS.STREET',
            'ADDRESS.ZIP',
            'ADDRESS.CITY',
            'ADDRESS.COUNTRY',
            'CONTACT.EMAIL',
        );

        $errors            = array();
        $notSetTranslation = $this->module->l('is not set, but mandatory!');
        $emptyTranslation  = $this->module->l('is set, but empty!');
        foreach ($mandatoryFields as $mandatoryField) {
            if (false == isset($formularParameters[$mandatoryField])) {
                $errors[$mandatoryField] = "{$mandatoryField} $notSetTranslation";
                continue;
            }
            if (empty($formularParameters[$mandatoryField])) {
                $errors[$mandatoryField] = "{$mandatoryField} $emptyTranslation";
                continue;
            }
        }

        return $errors;
    }
}
