<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    D3 Data Development
 * @copyright 2016 D3 Data Development
 * @license   LICENSE.txt
 */

if (!defined('_PS_VERSION_')) {
    exit;
}
include('libraries/vendor/autoload.php');
include_once('models/HeidelpayTransactionModel.php');

/**
 * Class Heidelpay
 */
class Heidelpay extends PaymentModule
{
    protected $config_form = false;

    /**
     *
     */
    public function __construct()
    {
        $this->name             = 'heidelpay';
        $this->tab              = 'payments_gateways';
        $this->version          = '1.0.7';
        $this->author           = 'D3 Data Development';
        $this->need_instance    = 1;
        $this->controllers      = array('validation');
        $this->is_eu_compatible = 1;
        $this->module_key       = '6c4396ea0905bf9a88aee58aafa8b60a';

        $this->currencies = false;

        /**
         * Set $this->bootstrap to true if your module is compliant with bootstrap (PrestaShop 1.6)
         */
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Heidelpay');
        $this->description = $this->l('Heidelpay module.');

        $this->confirmUninstall = $this->l('Soll das Heidelpay-Modul deinstalliert werden?');

        $this->ps_versions_compliancy = array('min' => '1.6.1', 'max' => '1.6.99');
    }

    /**
     * Don't forget to create update methods if needed:
     * http://doc.prestashop.com/display/PS16/Enabling+the+Auto-Update
     */
    public function install()
    {
        if (Shop::isFeatureActive()) {
            Shop::setContext(Shop::CONTEXT_ALL);
        }

        if (extension_loaded('curl') == false) {
            $this->_errors[] = $this->l('You have to enable the cURL extension on your server to install this module');

            return false;
        }

        Configuration::updateValue('HEIDELPAY_ACTIVE_MODE', false);
        Configuration::updateValue('HEIDELPAY_LIVE_MODE', false);
        Configuration::updateValue('HEIDELPAY_DEBUG_MODE', false);
        Configuration::updateValue('HEIDELPAY_ACCOUNT_SECURITYSENDER', '31HA07BC814F859E7F1D5A6D2C8291CE');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_LOGIN', '31ha07bc814f859e7f1d4cfc94291e67');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_PASSWORD', 'A10147A7');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_ACTIVE_DC', '0');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_CHANNEL_DC', '31HA07BC814F859E7F1D538FE598D9A8');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_TRANSTYPE_DC', 'PA');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_ACTIVE_CC', '0');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_CHANNEL_CC', '31HA07BC814F859E7F1D538FE598D9A8');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_TRANSTYPE_CC', 'PA');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_ACTIVE_DD', '0');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_CHANNEL_DD', '31HA07BC814F859E7F1D538FE598D9A8');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_TRANSTYPE_DD', 'DB');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_ACTIVE_SOFORT', '0');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_CHANNEL_SOFORT', '31HA07BC814F859E7F1D538FE598D9A8');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_ACTIVE_IDEAL', '0');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_CHANNEL_IDEAL', '31HA07BC814F859E7F1D1265097BFCF8');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_ACTIVE_PAYPAL', '0');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_CHANNEL_PAYPAL', '31HA07BC8142C5A17174245678D00F59');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_TRANSTYPE_PAYPAL', 'DB');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_ACTIVE_ASSUREDINV', '0');
        Configuration::updateValue('HEIDELPAY_ACCOUNT_CHANNEL_ASSUREDINV', '31HA07BC814F859E7F1D538FE598D9A8');
        Configuration::updateValue('HEIDELPAY_SECRET', openssl_random_pseudo_bytes(512));

        if (false == Configuration::get('HEIDELPAY_STATE_WAITING')) {
            $orderState       = new OrderState();
            $orderState->name = array();

            foreach (Language::getLanguages() as $language) {
                if (Tools::strtolower($language['iso_code']) == 'de') {
                    $orderState->name[$language['id_lang']] = 'Warten auf Bezahlung (Heidelpay)';
                } else {
                    $orderState->name[$language['id_lang']] = 'waiting for payment (heidelpay)';
                }
            }

            $orderState->send_email  = false;
            $orderState->color       = '#4169E1';
            $orderState->hidden      = false;
            $orderState->module_name = 'heidelpay';
            $orderState->delivery    = false;
            $orderState->logable     = true;
            $orderState->invoice     = false;
            $orderState->unremovable = true;
            $orderState->add();
            Configuration::updateValue('HEIDELPAY_STATE_WAITING', (int)$orderState->id);
        }

        //include(dirname(__FILE__).'/sql/install.php');

        return parent::install() &&
        $this->registerHook('header') &&
        $this->registerHook('backOfficeHeader') &&
        $this->registerHook('displayPDFInvoice') &&
        $this->registerHook('DisplayPayment') &&
        $this->registerHook('displayPaymentReturn') &&
        HeidelpayTransactionModel::createTables() &&
        $this->registerHook('advancedPaymentOptions');
    }

    /**
     * @return bool
     */
    public function uninstall()
    {
        $this->unregisterHook('header');
        $this->unregisterHook('backOfficeHeader');
        $this->unregisterHook('displayPDFInvoice');
        $this->unregisterHook('DisplayPayment');
        $this->unregisterHook('displayPaymentReturn');
        $this->unregisterHook('advancedPaymentOptions');

        Configuration::deleteByName('HEIDELPAY_ACTIVE_MODE');
        Configuration::deleteByName('HEIDELPAY_LIVE_MODE');
        Configuration::deleteByName('HEIDELPAY_DEBUG_MODE');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_SECURITYSENDER');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_LOGIN');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_PASSWORD');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_ACTIVE_DC');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_CHANNEL_DC');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_TRANSTYPE_DC');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_ACTIVE_CC');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_CHANNEL_CC');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_TRANSTYPE_CC');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_ACTIVE_DD');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_CHANNEL_DD');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_TRANSTYPE_DD');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_ACTIVE_SOFORT');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_CHANNEL_SOFORT');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_ACTIVE_IDEAL');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_CHANNEL_IDEAL');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_ACTIVE_PAYPAL');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_CHANNEL_PAYPAL');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_TRANSTYPE_PAYPAL');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_ACTIVE_ASSUREDINV');
        Configuration::deleteByName('HEIDELPAY_ACCOUNT_CHANNEL_ASSUREDINV');

        $orderStateId = Configuration::get('HEIDELPAY_STATE_WAITING');
        if ($orderStateId) {
            $orderState     = new OrderState();
            $orderState->id = $orderStateId;
            $orderState->delete();
        }
        Configuration::deleteByName('HEIDELPAY_STATE_WAITING');

        //include(dirname(__FILE__).'/sql/uninstall.php');

        return parent::uninstall() && HeidelpayTransactionModel::dropTables();
    }

    /**
     * Load the configuration form
     */
    public function getContent()
    {
        /**
         * If values have been submitted in the form, process.
         */
        if (((bool)Tools::isSubmit('submitHeidelpayModule')) == true) {
            $this->postProcess();
        }

        $this->context->smarty->assign('module_dir', $this->_path);

        $output = $this->context->smarty->fetch($this->local_path . 'views/templates/admin/configure.tpl');

        return $output . $this->renderForm();
    }

    /**
     * Create the form that will be displayed in the configuration of your module.
     */
    protected function renderForm()
    {
        $helper = new HelperForm();

        $helper->show_toolbar             = false;
        $helper->table                    = $this->table;
        $helper->module                   = $this;
        $helper->default_form_language    = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier    = $this->identifier;
        $helper->submit_action = 'submitHeidelpayModule';
        $helper->currentIndex  = $this->context->link->getAdminLink('AdminModules', false)
            . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token         = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(), /* Add values for your inputs */
            'languages'    => $this->context->controller->getLanguages(),
            'id_language'  => $this->context->language->id,
        );

        return $helper->generateForm(array($this->getConfigForm()));
    }

    /**
     * Create the structure of your form.
     */
    protected function getConfigForm()
    {
        return array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('Settings'),
                    'icon'  => 'icon-cogs',
                ),
                'input'  => array(

                    array(
                        'type'    => 'switch',
                        'label'   => $this->l('Aktiv'),
                        'name'    => 'HEIDELPAY_ACTIVE_MODE',
                        'is_bool' => true,
                        'values'  => array(
                            array(
                                'id'    => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id'    => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),

                    array(
                        'type'    => 'switch',
                        'label'   => $this->l('Live mode'),
                        'name'    => 'HEIDELPAY_LIVE_MODE',
                        'is_bool' => true,
                        'desc'    => $this->l('Use this module in live mode'),
                        'values'  => array(
                            array(
                                'id'    => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id'    => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'type'    => 'switch',
                        'label'   => $this->l('Debug mode'),
                        'name'    => 'HEIDELPAY_DEBUG_MODE',
                        'is_bool' => true,
                        'desc'    => $this->l('Use this module in debug mode'),
                        'values'  => array(
                            array(
                                'id'    => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id'    => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),

                    array(
                        'col'  => 8,
                        'type' => 'html',
                        'name' => 'Die folgenden Parameter werden Ihnen von Heidelpay gestellt.',
                    ),

                    array(
                        'col'   => 4,
                        'type'  => 'text',
                        'name'  => 'HEIDELPAY_ACCOUNT_SECURITYSENDER',
                        'label' => $this->l('Sender-ID'),
                    ),

                    array(
                        'col'   => 4,
                        'type'  => 'text',
                        'name'  => 'HEIDELPAY_ACCOUNT_LOGIN',
                        'label' => $this->l('Login'),
                    ),

                    array(
                        'type'  => 'password',
                        'name'  => 'HEIDELPAY_ACCOUNT_PASSWORD',
                        'label' => $this->l('Password'),
                    ),

                    array(
                        'col'  => 8,
                        'type' => 'html',
                        'name' => '<hr>',
                    ),

                    array(
                        'type'    => 'switch',
                        'label'   => $this->l('Debitkarte'),
                        'name'    => 'HEIDELPAY_ACTIVE_DC',
                        'is_bool' => true,
                        'values'  => array(
                            array(
                                'id'    => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id'    => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),

                    array(
                        'col'   => 4,
                        'type'  => 'text',
                        'name'  => 'HEIDELPAY_ACCOUNT_CHANNEL_DC',
                        'label' => $this->l('Channel Debitkarte'),
                        'id'    => 'HEIDELPAY_ACTIVE_DC_OPTION1',
                    ),

                    array(
                        'type'          => 'select',
                        'options'       => array(
                            'id'    => 'valueid',
                            'name'  => 'nameid',
                            'query' => array(
                                $this->getAuthOption('DB', 'Betrag sofort abbuchen'),
                                $this->getAuthOption('PA', 'Betrag nur reservieren'),
                            ),
                        ),
                        'empty_message' => 'Bitte wählen',
                        'size'          => 1,
                        'name'          => 'HEIDELPAY_ACCOUNT_TRANSTYPE_DC',
                        'label'         => $this->l('Buchungstyp'),
                        'id'            => 'HEIDELPAY_ACTIVE_DC_OPTION2',
                    ),

                    array(
                        'col'  => 8,
                        'type' => 'html',
                        'name' => '<hr id="HEIDELPAY_ACTIVE_DC_OPTION9">',
                    ),

                    array(
                        'type'    => 'switch',
                        'label'   => $this->l('Kreditkarte'),
                        'name'    => 'HEIDELPAY_ACTIVE_CC',
                        'is_bool' => true,
                        'values'  => array(
                            array(
                                'id'    => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id'    => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),

                    array(
                        'col'   => 4,
                        'type'  => 'text',
                        'name'  => 'HEIDELPAY_ACCOUNT_CHANNEL_CC',
                        'label' => $this->l('Channel Kreditkarte'),
                        'id'    => 'HEIDELPAY_ACTIVE_CC_OPTION1',
                    ),

                    array(
                        'type'          => 'select',
                        'options'       => array(
                            'id'    => 'valueid',
                            'name'  => 'nameid',
                            'query' => array(
                                $this->getAuthOption('DB', 'Betrag sofort abbuchen'),
                                $this->getAuthOption('PA', 'Betrag nur reservieren'),
                            ),
                        ),
                        'empty_message' => 'Bitte wählen',
                        'size'          => 1,
                        'name'          => 'HEIDELPAY_ACCOUNT_TRANSTYPE_CC',
                        'label'         => $this->l('Buchungstyp'),
                        'id'            => 'HEIDELPAY_ACTIVE_CC_OPTION2',
                    ),

                    array(
                        'col'  => 8,
                        'type' => 'html',
                        'name' => '<hr id="HEIDELPAY_ACTIVE_CC_OPTION9">',
                    ),

                    array(
                        'type'    => 'switch',
                        'label'   => $this->l('Bankeinzug'),
                        'name'    => 'HEIDELPAY_ACTIVE_DD',
                        'is_bool' => true,
                        'values'  => array(
                            array(
                                'id'    => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id'    => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),

                    array(
                        'col'   => 4,
                        'type'  => 'text',
                        'name'  => 'HEIDELPAY_ACCOUNT_CHANNEL_DD',
                        'label' => $this->l('Channel Bankeinzug'),
                        'id'    => 'HEIDELPAY_ACTIVE_DD_OPTION1',
                    ),

                    array(
                        'type'          => 'select',
                        'options'       => array(
                            'id'    => 'valueid',
                            'name'  => 'nameid',
                            'query' => array(
                                $this->getAuthOption('DB', 'Betrag sofort abbuchen'),
                                $this->getAuthOption('PA', 'Betrag nur reservieren'),
                            ),
                        ),
                        'empty_message' => 'Bitte wählen',
                        'size'          => 1,
                        'name'          => 'HEIDELPAY_ACCOUNT_TRANSTYPE_DD',
                        'label'         => $this->l('Buchungstyp'),
                        'id'            => 'HEIDELPAY_ACTIVE_DD_OPTION2',
                    ),

                    array(
                        'col'  => 8,
                        'type' => 'html',
                        'name' => '<hr id="HEIDELPAY_ACTIVE_DD_OPTION9">',
                    ),

                    array(
                        'type'    => 'switch',
                        'label'   => $this->l('Sofortueberweisung'),
                        'name'    => 'HEIDELPAY_ACTIVE_SOFORT',
                        'is_bool' => true,
                        'values'  => array(
                            array(
                                'id'    => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id'    => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),

                    array(
                        'col'   => 4,
                        'type'  => 'text',
                        'name'  => 'HEIDELPAY_ACCOUNT_CHANNEL_SOFORT',
                        'label' => $this->l('Channel Sofortueberweisung'),
                        'id'    => 'HEIDELPAY_ACTIVE_SOFORT_OPTION1',
                    ),

                    array(
                        'col'  => 8,
                        'type' => 'html',
                        'name' => '<hr id="HEIDELPAY_ACTIVE_SOFORT_OPTION9">',
                    ),

                    array(
                        'type'    => 'switch',
                        'label'   => $this->l('iDeal'),
                        'name'    => 'HEIDELPAY_ACTIVE_IDEAL',
                        'is_bool' => true,
                        'values'  => array(
                            array(
                                'id'    => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id'    => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),

                    array(
                        'col'   => 4,
                        'type'  => 'text',
                        'name'  => 'HEIDELPAY_ACCOUNT_CHANNEL_IDEAL',
                        'label' => $this->l('Channel iDeal'),
                        'id'    => 'HEIDELPAY_ACTIVE_IDEAL_OPTION1',
                    ),

                    array(
                        'col'  => 8,
                        'type' => 'html',
                        'name' => '<hr id="HEIDELPAY_ACTIVE_IDEAL_OPTION9">',
                    ),

                    array(
                        'type'    => 'switch',
                        'label'   => $this->l('Paypal'),
                        'name'    => 'HEIDELPAY_ACTIVE_PAYPAL',
                        'is_bool' => true,
                        'values'  => array(
                            array(
                                'id'    => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id'    => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),

                    array(
                        'col'   => 4,
                        'type'  => 'text',
                        'name'  => 'HEIDELPAY_ACCOUNT_CHANNEL_PAYPAL',
                        'label' => $this->l('Channel Paypal'),
                        'id'    => 'HEIDELPAY_ACTIVE_PAYPAL_OPTION1',
                    ),

                    array(
                        'type'          => 'select',
                        'options'       => array(
                            'id'    => 'valueid',
                            'name'  => 'nameid',
                            'query' => array(
                                $this->getAuthOption('DB', 'Betrag sofort abbuchen'),
                                $this->getAuthOption('PA', 'Betrag nur reservieren'),
                            ),
                        ),
                        'empty_message' => 'Bitte wählen',
                        'size'          => 1,
                        'name'          => 'HEIDELPAY_ACCOUNT_TRANSTYPE_PAYPAL',
                        'label'         => $this->l('Buchungstyp'),
                        'id'            => 'HEIDELPAY_ACTIVE_PAYPAL_OPTION2',
                    ),

                    array(
                        'col'  => 8,
                        'type' => 'html',
                        'name' => '<hr id="HEIDELPAY_ACTIVE_PAYPAL_OPTION9">',
                    ),

                    array(
                        'type'    => 'switch',
                        'label'   => $this->l('Rechnungskauf'),
                        'name'    => 'HEIDELPAY_ACTIVE_ASSUREDINV',
                        'is_bool' => true,
                        'values'  => array(
                            array(
                                'id'    => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id'    => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),

                    array(
                        'col'   => 4,
                        'type'  => 'text',
                        'name'  => 'HEIDELPAY_ACCOUNT_CHANNEL_ASSUREDINV',
                        'label' => $this->l('Channel Rechnungskauf'),
                        'id'    => 'HEIDELPAY_ACTIVE_ASSUREDINV_OPTION1',
                    ),

                    array(
                        'col'  => 8,
                        'type' => 'html',
                        'name' => '<hr id="HEIDELPAY_ACTIVE_ASSUREDINV_OPTION9">',
                    ),

                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                ),
            ),
        );
    }

    /**
     * @param $sValue
     * @param $sName
     *
     * @return stdClass
     */
    protected function getAuthOption($sValue, $sName)
    {
        $oOption          = new stdClass;
        $oOption->valueid = $sValue;
        $oOption->nameid  = $sName;

        return $oOption;
    }

    /**
     * Set values for the inputs.
     */
    protected function getConfigFormValues()
    {
        return array(
            'HEIDELPAY_LIVE_MODE'              => Configuration::get('HEIDELPAY_LIVE_MODE', false),
            'HEIDELPAY_DEBUG_MODE'             => Configuration::get('HEIDELPAY_DEBUG_MODE', false),
            'HEIDELPAY_ACTIVE_MODE'            => Configuration::get('HEIDELPAY_ACTIVE_MODE', false),
            'HEIDELPAY_ACCOUNT_SECURITYSENDER' => Configuration::get('HEIDELPAY_ACCOUNT_SECURITYSENDER', ''),
            'HEIDELPAY_ACCOUNT_LOGIN'          => Configuration::get('HEIDELPAY_ACCOUNT_LOGIN', ''),
            'HEIDELPAY_ACCOUNT_PASSWORD'       => Configuration::get('HEIDELPAY_ACCOUNT_PASSWORD', null),

            'HEIDELPAY_ACTIVE_DC'            => Configuration::get('HEIDELPAY_ACTIVE_DC', '0'),
            'HEIDELPAY_ACCOUNT_CHANNEL_DC'   => Configuration::get(
                'HEIDELPAY_ACCOUNT_CHANNEL_DC',
                '31HA07BC814F859E7F1D538FE598D9A8'
            ),
            'HEIDELPAY_ACCOUNT_TRANSTYPE_DC' => Configuration::get('HEIDELPAY_ACCOUNT_TRANSTYPE_DC', null),

            'HEIDELPAY_ACTIVE_CC'            => Configuration::get('HEIDELPAY_ACTIVE_CC', '0'),
            'HEIDELPAY_ACCOUNT_CHANNEL_CC'   => Configuration::get(
                'HEIDELPAY_ACCOUNT_CHANNEL_CC',
                '31HA07BC814F859E7F1D538FE598D9A8'
            ),
            'HEIDELPAY_ACCOUNT_TRANSTYPE_CC' => Configuration::get('HEIDELPAY_ACCOUNT_TRANSTYPE_CC', null),

            'HEIDELPAY_ACTIVE_DD'            => Configuration::get('HEIDELPAY_ACTIVE_DD', '0'),
            'HEIDELPAY_ACCOUNT_CHANNEL_DD'   => Configuration::get(
                'HEIDELPAY_ACCOUNT_CHANNEL_DD',
                '31HA07BC814F859E7F1D538FE598D9A8'
            ),
            'HEIDELPAY_ACCOUNT_TRANSTYPE_DD' => Configuration::get('HEIDELPAY_ACCOUNT_TRANSTYPE_DD', null),

            'HEIDELPAY_ACTIVE_SOFORT'          => Configuration::get('HEIDELPAY_ACTIVE_SOFORT', '0'),
            'HEIDELPAY_ACCOUNT_CHANNEL_SOFORT' => Configuration::get(
                'HEIDELPAY_ACCOUNT_CHANNEL_SOFORT',
                '31HA07BC814F859E7F1D538FE598D9A8'
            ),

            'HEIDELPAY_ACTIVE_IDEAL'          => Configuration::get('HEIDELPAY_ACTIVE_IDEAL', '0'),
            'HEIDELPAY_ACCOUNT_CHANNEL_IDEAL' => Configuration::get(
                'HEIDELPAY_ACCOUNT_CHANNEL_IDEAL',
                ''
            ),

            'HEIDELPAY_ACTIVE_PAYPAL'            => Configuration::get('HEIDELPAY_ACTIVE_PAYPAL', '0'),
            'HEIDELPAY_ACCOUNT_CHANNEL_PAYPAL'   => Configuration::get(
                'HEIDELPAY_ACCOUNT_CHANNEL_PAYPAL',
                '31HA07BC8142C5A17174245678D00F59'
            ),
            'HEIDELPAY_ACCOUNT_TRANSTYPE_PAYPAL' => Configuration::get('HEIDELPAY_ACCOUNT_TRANSTYPE_PAYPAL', null),

            'HEIDELPAY_ACTIVE_ASSUREDINV'          => Configuration::get('HEIDELPAY_ACTIVE_ASSUREDINV', '0'),
            'HEIDELPAY_ACCOUNT_CHANNEL_ASSUREDINV' => Configuration::get(
                'HEIDELPAY_ACCOUNT_CHANNEL_ASSUREDINV',
                ''
            ),
        );
    }

    /**
     * Save form data.
     */
    protected function postProcess()
    {
        $form_values = $this->getConfigFormValues();

        foreach (array_keys($form_values) as $key) {
            $value = Tools::getValue($key);
            if ($key === 'HEIDELPAY_ACCOUNT_PASSWORD' && empty($value)) {
                continue;
            }
            Configuration::updateValue($key, trim($value));
        }
    }

    /**
     * Add the CSS & JavaScript files you want to be loaded in the BO.
     */
    public function hookBackOfficeHeader()
    {
        if (Tools::getValue('configure') == $this->name) {
            $this->context->controller->addJS($this->_path . 'views/js/back.js');
            //$this->context->controller->addCSS($this->_path.'views/css/back.css');
        }
    }

    /**
     * Add the CSS & JavaScript files you want to be added on the FO.
     */
    public function hookHeader()
    {
        // $this->context->controller->addJS($this->_path.'/views/js/front.js');
        //$this->context->controller->addCSS(_MODULE_DIR_.$this->name.'/views/css/front.css');
    }

    /**
     * This method is used to render the payment button,
     * Take care if the button should be displayed or not.
     */
    /**
     * payment modifications for shops outside EU or without EU compliant order process
     *
     * @param $params
     *
     * @return string
     */
    public function hookDisplayPayment($params)
    {
        if (!$this->active) {
            return null;
        }

        $this->smarty->assign('module_dir', $this->_path);
        $blModuleActive = Configuration::get('HEIDELPAY_ACTIVE_MODE', false);

        $this->context->smarty->assign(
            array(
                'DC_active'         => $blModuleActive && Configuration::get('HEIDELPAY_ACTIVE_DC', 0),
                'CC_active'         => $blModuleActive && Configuration::get('HEIDELPAY_ACTIVE_CC', 0),
                'DD_active'         => $blModuleActive && Configuration::get('HEIDELPAY_ACTIVE_DD', 0),
                'SOFORT_active'     => $blModuleActive && Configuration::get('HEIDELPAY_ACTIVE_SOFORT', 0),
                'IDEAL_active'      => $blModuleActive && Configuration::get('HEIDELPAY_ACTIVE_IDEAL', 0),
                'PAYPAL_active'     => $blModuleActive && Configuration::get('HEIDELPAY_ACTIVE_PAYPAL', 0),
                'ASSUREDINV_active' => $blModuleActive && Configuration::get('HEIDELPAY_ACTIVE_ASSUREDINV', 0),
            )
        );

        return $this->display(__FILE__, 'views/templates/hook/payment.tpl');
    }

    /**
     * payment modifications for shops inside EU with EU compliant order process
     *
     * @param $params
     *
     * @return string
     */
    public function hookAdvancedPaymentOptions($params)
    {
        if (!$this->active) {
            return null;
        }

        if (false == Configuration::get('AEUC_FEAT_ADV_PAYMENT_API')) {
            return null;
        }

        if (false == Configuration::get('HEIDELPAY_ACTIVE_MODE', false)) {
            return null;
        }

        $this->smarty->assign('module_dir', $this->_path);

        $payments       = array(
            'dc'         => array(
                'isActive' => Configuration::get('HEIDELPAY_ACTIVE_DC', 0),
                'title'    => 'debitcard_title',
                'id'       => 'debitcard',
            ),
            'cc'         => array(
                'isActive' => Configuration::get('HEIDELPAY_ACTIVE_CC', 0),
                'title'    => 'creditcard_title',
                'id'       => 'creditcard',
            ),
            'dd'         => array(
                'isActive' => Configuration::get('HEIDELPAY_ACTIVE_DD', 0),
                'title'    => 'directdebit_title',
                'id'       => 'directdebit',
            ),
            'sofort'     => array(
                'isActive' => Configuration::get('HEIDELPAY_ACTIVE_SOFORT', 0),
                'title'    => 'sofortueberweisung_title',
                'id'       => 'sofort',
            ),
            'ideal'      => array(
                'isActive' => Configuration::get('HEIDELPAY_ACTIVE_IDEAL', 0),
                'title'    => 'ideal_title',
                'id'       => 'ideal',
            ),
            'paypal'     => array(
                'isActive' => Configuration::get('HEIDELPAY_ACTIVE_PAYPAL', 0),
                'title'    => 'paypal_title',
                'id'       => 'paypal',
            ),
            'assuredinv' => array(
                'isActive' => Configuration::get('HEIDELPAY_ACTIVE_ASSUREDINV', 0),
                'title'    => 'assuredinvoice_title',
                'id'       => 'assuredinvoice',
            ),
        );
        $activePayments = array();
        foreach ($payments as $payment => $paymentInfos) {
            if ($paymentInfos['isActive']) {
                $activePayments['heidelpay_' . $payment] = array(
                    'cta_text' => $this->l($paymentInfos['title'], $this->name . '_' . $payment),
                    'logo'     => Media::getMediaPath(
                        _PS_MODULE_DIR_ . $this->name . '/views/img/' . $this->name . '_' . $paymentInfos['id'] . '.png'
                    ),
                    'action'   => $this->context->link->getModuleLink('heidelpay', $paymentInfos['id'], array(), true)
                );
            }
        }
        $newOptions = array();
        if ($activePayments) {
            foreach ($activePayments as $legacyOption) {
                if (false == $legacyOption) {
                    continue;
                }

                foreach (Core_Business_Payment_PaymentOption::convertLegacyOption($legacyOption) as $option) {
                    /** @var $option Core_Business_Payment_PaymentOption */
                    $option->setModuleName($this->name);
                    $newOptions[] = $option;
                }
            }

            return $newOptions;
        }

        return null;
    }

    public function hookDisplayPaymentReturn($params)
    {
        if ($this->active == false) {
            return false;
        }
        /** @var order $order */
        $order = $params['objOrder'];

        if ($order->getCurrentOrderState()->id != Configuration::get('PS_OS_ERROR')) {
            $this->smarty->assign('status', 'ok');
        }

        $this->smarty->assign(
            array(
                'id_order'  => $order->id,
                'reference' => $order->reference,
                'params'    => $params,
                'total'     => Tools::displayPrice($params['total_to_pay'], $params['currencyObj'], false),
            )
        );

        return $this->display(__FILE__, 'views/templates/hook/confirmation.tpl');
    }

    public function hookDisplayHeader()
    {
        /* Place your code here. */
        $this->context->controller->addCSS(_MODULE_DIR_ . $this->name . '/views/css/front.css');
    }

    public function hookDisplayPDFInvoice($params)
    {
        $isObjectNotSet     = false == isset($params['object']);
        $isObjectNotInvoice = false == ($params['object'] instanceof HTMLTemplateInvoiceCore);
        if ($this->active == false && $isObjectNotSet && $isObjectNotInvoice) {
            PrestaShopLogger::addLog(
                'HeidelpayResponse::hookDisplayPDF: ' . __LINE__,
                1,
                null,
                'Heidelpay Module',
                (int)$this->context->cart->id,
                true
            );

            return false;
        }

        /** @var HTMLTemplateInvoice $invoice */
        $invoice = $params['object'];

        $records = HeidelpayTransactionModel::hydrateCollection(
            'HeidelpayTransactionModel',
            Db::getInstance()->executeS(
                'SELECT * FROM `' . _DB_PREFIX_ . 'heidelpayTransactions` ' //
                . 'WHERE `id_transactiongroup` = ' . (int)($invoice->id_order) . ' LIMIT 1'
            )
        );

        /** @var HeidelpayTransactionModel $activeRecord */
        $activeRecord = current($records);

        if (false === $activeRecord) {
            PrestaShopLogger::addLog(
                'HeidelpayResponse::hookDisplayPDF: ' . __LINE__ //
                . 'SELECT * FROM `' . _DB_PREFIX_ . 'heidelpayTransactions` ' //
                . 'WHERE `id_transactiongroup` = ' . (int)($invoice->id_order) . ' LIMIT 1',
                1,
                null,
                'Heidelpay Module',
                (int)$this->context->cart->id,
                true
            );

            return "";
        }
        require_once(dirname(__FILE__) . '/controllers/front/heidelpay.php');

        /** @var BlowFishCore $blowFish */
        $blowFish        = new Blowfish(
            HeidelpayModuleFrontController::BLOFISH_KEY,
            HeidelpayModuleFrontController::BLOFISH_VALUE
        );
        $transactionData = Tools::jsonDecode($blowFish->decrypt($activeRecord->transaction_data), true);

        $transaction = new d3\heidelpay\transactionlog\reader\Transaction();
        $transaction->read($transactionData);
        // isses channel von asssureinv ?? -> wenn nein Return
        // hol die Parameter 'Clearance_*' und 'CONNECTOR_*'
        // CRITERION.SESSION nutzen!
        if (false == is_array($transactionData) || false === isset($transactionData['CRITERION_SESSION'])) {
            PrestaShopLogger::addLog(
                'HeidelpayResponse::hookDisplayPDF: ' . var_export($transactionData, true),
                1,
                null,
                'Heidelpay Module',
                (int)$this->context->cart->id,
                true
            );

            return '';
        }

        $aTmp                     = explode("__@@", $transactionData['CRITERION_SESSION']);
        $heidelpay_input_position = $aTmp[0];
        if ($heidelpay_input_position !== 'assuredinvoice') {
            PrestaShopLogger::addLog(
                'HeidelpayResponse::hookDisplayPDF: ' . __LINE__,
                1,
                null,
                'Heidelpay Module',
                (int)$this->context->cart->id,
                true
            );

            return '';
        }

        $this->smarty->assign(
            array(
                'response' => $transactionData,
            )
        );
##
        $result = $this->display(__FILE__, 'views/templates/hook/displaypdf.tpl');

        return $result;
    }

    public function hookRightColumn()
    {
        return '';
    }

    public function hookLeftColumn()
    {
        return $this->hookRightColumn();
    }
}
