<?php
namespace d3\heidelpay\payment;

use d3\heidelpay\Redirect;
use d3\heidelpay\request\pattern\AbstractPattern;
use d3\heidelpay\response\Parser;

/**
 * Class AbstractPayment
 */
abstract class AbstractPayment
{
    /**
     * Returns class name.
     *
     * @return string class name
     */
    public function __toString()
    {
        return get_class($this);
    }

    /**
     * returns the payment code (CC, DD, PP, DC, etc..)
     *
     * @return string
     */
    abstract public function getPaymentCode();

    /**
     * Returns the avaiable payment types for this payment
     *
     * @return array
     */
    abstract public function getPaymentTypes();

    /**
     * Returns the requested xml pattern for this payment
     *
     * @return AbstractPattern
     */
    abstract public function getRequestXmlPattern();

    /**
     * returns dynamic values for this payment
     *
     * @param Parser $oParser
     *
     * @return array
     */
    abstract public function getDynamicValues(Parser $oParser);

    /**
     * @return redirect
     */
    abstract public function getRedirect();
}
