<?php
namespace d3\heidelpay\payment;

use d3\heidelpay\Redirect;
use d3\heidelpay\response\Parser;
use d3\heidelpay\request\pattern\Directdebit as PatternDirectdebit;

/**
 * Class Directdebit
 */
class Directdebit extends AbstractPayment
{
    /**
     * {@inheritdoc}
     */
    public function getRequestXmlPattern()
    {
        return new PatternDirectdebit();
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentCode()
    {
        return 'DD';
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentTypes()
    {
        return array('DB', 'RF', 'RV');
    }

    /**
     * Returns bank data from parser.
     *
     * @param Parser $oParser
     *
     * @return array
     */
    public function getDynamicValues(Parser $oParser)
    {
        return $oParser->getBankData();
    }

    /**
     * @return redirect
     */
    public function getRedirect()
    {
        return new redirect();
    }
}
