<?php
namespace d3\heidelpay\payment;

use d3\heidelpay\Redirect;
use d3\heidelpay\response\Parser;
use d3\heidelpay\request\pattern\PrePayment as PatternPrePayment;

/**
 * Class Prepayment
 */
class Prepayment extends AbstractPayment
{
    /**
     * {@inheritdoc}
     */
    public function getRequestXmlPattern()
    {
        return new PatternPrePayment();
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentCode()
    {
        return 'PP';
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentTypes()
    {
        return array('PA', 'RC', 'RF');
    }

    /**
     * returns empty array
     *
     * @param Parser $oParser
     *
     * @return array
     */
    public function getDynamicValues(Parser $oParser)
    {
        return array();
    }

    /**
     * @return redirect
     */
    public function getRedirect()
    {
        return new redirect();
    }
}
