<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 *  @author    D3 Data Development
 *  @copyright 2016 D3 Data Development
 *  @license   LICENSE.txt
 */

/**
 * Class HeidelpayTransactionModel
 */
class HeidelpayTransactionModel extends ObjectModel
{
    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table'   => 'heidelpayTransactions',
        'primary' => 'id_heidelpayTransactions',
        'fields'  => array(
            'id_heidelpayTransactions'            => array('type' => self::TYPE_INT),
            'id_transaction'      => array(
                'type'     => self::TYPE_STRING,
                'validate' => 'isGenericName',
                'required' => true,
                'size'     => 255
            ),
            'id_transactiongroup' => array(
                'type'     => self::TYPE_STRING,
                'validate' => 'isGenericName',
                'size'     => 255
            ),
            'id_customer' => array(
                'type'     => self::TYPE_INT,
                'size'     => 15
            ),
            'transaction_data'    => array(
                'type'     => self::TYPE_HTML,
                'required' => true
            ),
            'timestamp'           => array('type' => self::TYPE_DATE),
        ),
    );

    public $id_transaction;

    public $transaction_data;

    public $id_heidelpayTransactions;

    public $id_customer;

    public $id_transactiongroup;

    public static function createTables()
    {
        $sql = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'heidelpayTransactions` (
			`id_heidelpayTransactions` INT(15) NOT NULL AUTO_INCREMENT,
			`id_transaction` VARCHAR(255) NOT NULL,
			`id_transactiongroup` VARCHAR(255) NOT NULL,
			`id_customer` INT(15) NOT NULL,
			`transaction_data` TEXT NOT NULL,
			`timestamp` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
			PRIMARY KEY (`id_heidelpayTransactions`),
            UNIQUE KEY (`id_transaction`)
			) ENGINE = ' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8';

        return Db::getInstance()->execute($sql);
    }

    public static function dropTables()
    {
        $sql = 'DROP TABLE IF EXISTS `' . _DB_PREFIX_ . 'heidelpayTransactions`';

        return Db::getInstance()->execute($sql);
    }
}
