/*
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    D3 Data Development
*  @copyright 2016 D3 Data Development
*  @license   LICENSE.txt
*/

// payment type checkbox ids
var toggleElements = [
    "HEIDELPAY_ACTIVE_DC",
    "HEIDELPAY_ACTIVE_CC",
    "HEIDELPAY_ACTIVE_DD",
    "HEIDELPAY_ACTIVE_SOFORT",
    "HEIDELPAY_ACTIVE_IDEAL",
    "HEIDELPAY_ACTIVE_PAYPAL",
    "HEIDELPAY_ACTIVE_ASSUREDINV"
];

// max additional options per payment type
var iMaxOptionFields = 9;

var iIndex1;
var iIndex2;

function d3heidelpayAddListeners()
{
    for (iIndex1 = 0; iIndex1 < toggleElements.length; ++iIndex1) {
        d3heidelpayHideUncheckedElementOptions(toggleElements[iIndex1]);
        d3heidelpayAddInputListener(toggleElements[iIndex1]);
    }
}

function d3heidelpayAddInputListener(sElemId)
{
    var sRadioOnId  = sElemId + '_on';
    var sRadioOffId = sElemId + '_off';
    var oElem;

    if (oElem = document.getElementById(sElemId)) {
        d3heidelpayAddCheckboxListener(oElem);
    } else if (oElem = document.getElementById(sRadioOnId)) {
        d3heidelpayAddRadioListener(oElem, true);
        oElem = document.getElementById(sRadioOffId);
        d3heidelpayAddRadioListener(oElem, false);
    }
}

function d3heidelpayAddCheckboxListener(oElem) {
    if (oElem.addEventListener) {
        oElem.addEventListener(
            "change",
            d3heidelpayTogglePayments
        );
    } else if (oElem.attachEvent) {
        oElem.attachEvent(
            'onchange',
            d3heidelpayTogglePayments
        );
    }
}

function d3heidelpayAddRadioListener(oElem, blOn)
{
    var sFunction;
    if (blOn) {
        sFunction = d3heidelpayTogglePayments;
    } else {
        sFunction = d3heidelpayHidePayments;
    }

    if (oElem.addEventListener) {
        oElem.addEventListener(
            "change",
            sFunction
        );
    } else if (oElem.attachEvent) {
        oElem.attachEvent(
            'onchange',
            sFunction
        );
    }
}

function d3heidelpayTogglePayments(event)
{
    var oElem = event.target;

    for (iIndex2 = iMaxOptionFields; iIndex2 > 0; iIndex2--) {
        d3heidelpay_togglepaymentoptions(
            oElem,
            iIndex2,
            false
        );
    }
}

function d3heidelpayHidePayments(event)
{
    var oElem = event.target;

    for (iIndex2 = iMaxOptionFields; iIndex2 > 0; iIndex2--) {
        d3heidelpay_togglepaymentoptions(
            oElem,
            iIndex2,
            true
        );
    }
}

function d3heidelpayHideUncheckedElementOptions(sElementId)
{
    for (iIndex2 = iMaxOptionFields; iIndex2 > 0; iIndex2--) {
        if (document.getElementById(sElementId)) {
            d3heidelpay_togglepaymentoptions(document.getElementById(sElementId), iIndex2);
        } else if (document.getElementById(sElementId + '_on')) {
            d3heidelpay_togglepaymentoptions(document.getElementById(sElementId + '_on'), iIndex2);
        }
    }
}

function d3heidelpay_togglepaymentoptions(oElement, iCount, blInverse)
{
    var oToggleElement = d3heidelpayGetToggleElement(oElement.id, iCount);

    var sStyle1 = blInverse ? 'none' : 'block';
    var sStyle2 = blInverse ? 'block' : 'none';

    if (oToggleElement) {
        if (oElement.checked || oElement.selected) {
            oToggleElement.style.display = sStyle1;
        } else {
            oToggleElement.style.display = sStyle2;
        }
    }
}

function d3heidelpayGetToggleElement(sSourceId, iCount)
{
    sSourceId = sSourceId.replace("_on", "").replace("_off", "");

    var sNewId = sSourceId + '_OPTION' + iCount;

    if (document.getElementById(sNewId)) {
        var oBaseElement = document.getElementById(sNewId);
        return oBaseElement.parentNode.parentNode;
    }

    return false;
}

document.addEventListener("DOMContentLoaded", function() {
    d3heidelpayAddListeners();
});