{*
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    D3 Data Development
*  @copyright 2016 D3 Data Development
*  @license   LICENSE.txt
*}
{capture name=path}
    <a href="{$link->getPageLink('order', true, NULL, 'step=3')|escape:'html':'UTF-8'}"
       title="{l s='Go back to the checkout' mod='heidelpay'}">{l s='Checkout' mod='heidelpay'}</a>
    <span class="navigation-pipe">{$navigationPipe|escape:'html':'UTF-8'}</span>{l s='Heidelpay payment' mod='heidelpay'}
{/capture}

<h1 class="page-heading">{l s='Payment' mod='heidelpay'}</h1>

{assign var='current_step' value='payment'}
{include file="$tpl_dir./order-steps.tpl"}

<h2 class="page-subheading">{l s='Heidelpay payment' mod='heidelpay'}</h2>
{if $error_tpl}
    {include file=$error_tpl hideOrderSteps=true}
{/if}

<form id="paymentFrameForm"
      action="{$link->getModuleLink('heidelpay', 'ideal', [], true)|escape:'htmlall':'UTF-8'}"
      method="post">
    <div class="box">
        <label>
            {l s='please choose your bank' mod='heidelpay'}
            <select name="brand">
                {foreach from=$brands item='brandName' key='brandIdent'}
                    <option value="{$brandIdent|escape:'htmlall':'UTF-8'}">{$brandName|escape:'htmlall':'UTF-8'}</option>
                {/foreach}
            </select>
        </label>
    </div>

    <p class="cart_navigation clearfix">
        <a href="{$link->getPageLink('order', true, NULL, "step=3")|escape:'html':'UTF-8'}"
           class="button-exclusive btn btn-default">
            <i class="icon-chevron-left"></i>{l s='Other payment methods' mod='heidelpay'}
        </a>
        <button type="submit" id="heidelpayPayNowButton"
                class="button btn btn-default standard-checkout button-medium">
            <span>
                {l s='pay now' mod='heidelpay'}
                <i class="icon-chevron-right right"></i>
            </span>
        </button>
    </p>
</form>

