<?php
/**
 * NOTICE OF LICENSE
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    D3 Data Development
 * @copyright 2017 D3 Data Development
 * @license   LICENSE.txt
 */

use d3\heidelpay\blowfish\Blowfish;
use d3\heidelpay\Ngw;
use d3\heidelpay\ngw\Request;
use d3\heidelpay\payment\invoice\Secured;
use d3\heidelpay\request\Config;
use d3\heidelpay\transactionlog\reader\Transaction;

require_once(dirname(__FILE__).'/heidelpay.php'); // Base Controller
include_once(_PS_MODULE_DIR_.'/heidelpay/models/HeidelpayConfigModel.php');

/**
 * Class HeidelpayAssuredinvoiceModuleFrontController
 */
class HeidelpayAssuredinvoiceModuleFrontController extends HeidelpayModuleFrontController
{
    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     * @throws Exception
     */
    public function initContent()
    {
        $data = $this->getDataAssuredinvoice();
        if (isset($_REQUEST['NAME_BIRTHDATE']) && false == empty($_REQUEST['NAME_BIRTHDATE'])) {
            $data['NAME.BIRTHDATE'] = $_REQUEST['NAME_BIRTHDATE'];
        }
        $result = $this->validateBirthdate($data);

        if (false == empty($result)) {
            $this->context->smarty->assign('fields', $result);
            $this->context->smarty->assign(
                'formularUrl',
                $this->context->link->getModuleLink('heidelpay', 'assuredinvoice', array(), true)
            );
            $this->setTemplate("module:heidelpay/views/templates/front/hpfields.tpl");
            parent::initContent();

            return;
        }

        $basketValue = new HeidelpayBasketValueModel($this->context->cart);
        $config      = new HeidelpayConfigModel();
        $basket      = new HeidelpayBasketModel($basketValue, $config);

        $request = new Request();

        $request->setUrl($this->getHeidelpayUrl(true));
        $request->setCurlTimeOut($this->getHeidelpayCurlTimeOut());
        $request->setData($basket->getJsonObject());

        $ngw      = new Ngw();
        $response = $ngw->sendJSONRequest($request);

        $transaction = new Transaction();
        $transaction->read($response);

        if ($transaction->getResult() != "ACK") {
            PrestaShopLogger::addLog(
                'HeidelpayResponse::sendJSONBasket::NGW-response data: ' . var_export($response, true)
                . '::JSON::' . $basket->getJsonObject(),
                1,
                null,
                'Heidelpay Module',
                (int)$this->context->cart->id,
                true
            );

            $errors       = (array)current($transaction->getBasketErrors());
            $this->errors = $errors;
            $this->setTemplate("module:heidelpay/views/templates/front/errorpage.tpl");
            parent::initContent();

            return;
        }

        $data['BASKET.ID'] = $transaction->getBasketId();

        $result = $this->validateCustomerData($data);

        if (false == empty($result)) {
            $this->errors = $result;
            $this->setTemplate("module:heidelpay/views/templates/front/errorpage.tpl");
            parent::initContent();

            return;
        }

        $request = new Request();

        $request->setUrl($this->getHeidelpayUrl());
        $request->setCurlTimeOut($this->getHeidelpayCurlTimeOut());
        $request->setData($data);

        PrestaShopLogger::addLog(
            'HeidelpayResponse::initContent::NGW-request data: '.var_export($data, true),
            1,
            null,
            'Heidelpay Module',
            (int)$this->context->cart->id,
            true
        );

        $ngw      = new Ngw();
        $response = $ngw->sendPostRequest($request);

        PrestaShopLogger::addLog(
            'HeidelpayResponse::initContent::NGW-response data: '.var_export($response, true),
            1,
            null,
            'Heidelpay Module',
            (int)$this->context->cart->id,
            true
        );

        if (isset($response['PROCESSING_RESULT']) && 'ACK' === $response['PROCESSING_RESULT']) {
            if (isset($response['CRITERION_SESSION'])) {
                $aTmp                                 = explode("__@@", $response['CRITERION_SESSION']);
                $response['heidelpay_input_position'] = $aTmp[0];
                $response['id_customer']              = $aTmp[2];
            }

            $blowFish = new Blowfish(HeidelpayModuleFrontController::BLOFISH_KEY);

            $activeRecord                   = new HeidelpayTransactionModel();
            $activeRecord->id_transaction   = $response['IDENTIFICATION_UNIQUEID'];
            $activeRecord->id_customer      = $response['id_customer'];
            $activeRecord->transaction_data = $blowFish->encrypt($this->encode($response));
            if (false == $activeRecord->add()) {
                PrestaShopLogger::addLog(
                    __CLASS__.':: coult not save transaction to database',
                    2,
                    null,
                    'Heidelpay Module',
                    (int)$this->context->cart->id,
                    true
                );
            }

            $currentTransactionId = $activeRecord->id;

            Tools::redirect($this->context->link->getModuleLink(
                'heidelpay',
                'validation',
                array('currenttransactionid' => $currentTransactionId)
            ));
        }

        $this->setErrorTemplate($response['PROCESSING_RETURN_CODE']);
        parent::initContent();
    }

    /**
     * @return array
     * @throws Exception
     */
    protected function getDataAssuredinvoice()
    {
        $assuredinvoice  = new Secured();
        $billing_address = new Address($this->context->cart->id_address_invoice);

        $config = new Config();
        $config->setIsTestmode(!Configuration::get('HEIDELPAY_LIVE_MODE'));

        $config->setResponseUrl($this->context->link->getModuleLink('heidelpay', 'response'));

        $paymentCode = $assuredinvoice->getPaymentCode().".PA";

        $data                                 = array();
        $data['REQUEST.VERSION']              = "1.0";
        $data['SECURITY.SENDER']              = Configuration::get('HEIDELPAY_ACCOUNT_SECURITYSENDER');
        $data['FRONTEND.RESPONSE_URL']        = $config->getResponseUrl();
        $data['IDENTIFICATION.TRANSACTIONID'] = rand()."__@@".date('Ymd-Hms');
        $data['USER.LOGIN']                   = Configuration::get('HEIDELPAY_ACCOUNT_LOGIN');
        $data['USER.PWD']                     = Configuration::get('HEIDELPAY_ACCOUNT_PASSWORD');
        $data['TRANSACTION.MODE']             = $config->getTransactionMode();
        $data['TRANSACTION.RESPONSE']         = 'SYNC';
        $data['TRANSACTION.CHANNEL']          = Configuration::get('HEIDELPAY_ACCOUNT_CHANNEL_ASSUREDINV');
        $data['PAYMENT.CODE']                 = $paymentCode;
        $data['PRESENTATION.AMOUNT']          = $this->context->cart->getOrderTotal();
        $data['PRESENTATION.CURRENCY']        = $this->context->currency->iso_code;
        $data['NAME.GIVEN']                   = $this->context->customer->firstname;
        $data['NAME.FAMILY']                  = $this->context->customer->lastname;
        $data['NAME.COMPANY']                 = $this->context->customer->company;
        $data['NAME.BIRTHDATE']               = $this->context->customer->birthday;
        $data['CONTACT.EMAIL']                = $this->context->customer->email;
        $data['CONTACT.IP']                   = Tools::getRemoteAddr();
        $data['ADDRESS.COUNTRY']              = $this->context->country->iso_code;
        $data['ADDRESS.STREET']               = trim("{$billing_address->address1} {$billing_address->address2}");
        $data['ADDRESS.ZIP']                  = $billing_address->postcode;
        $data['ADDRESS.CITY']                 = $billing_address->city;
        $data['SHOP.TYPE']                    = "PrestaShop "._PS_VERSION_;
        $data['SHOPMODULE.VERSION']           = $this->module->version;
        $checksum                             = $this->context->cookie->getFamily('checksum')['checksum'];
        $data['CRITERION.SESSION']            = "assuredinvoice__@@".$checksum.'__@@'.$this->context->customer->id;
        $data['CRITERION.HASH']               = $this->generateHash($data);

        return $data;
    }

    /**
     * @param array $formularParameters
     *
     * @return array
     */
    public function validateBirthdate(array $formularParameters)
    {
        $mandatoryField = 'NAME.BIRTHDATE';
        $errors         = array();

        $emptyTranslation = $this->module->l('Please enter your birthdate (mandatory, format yyyy-mm-dd: 1999-12-31):');
        if (false == isset($formularParameters[$mandatoryField])
            || empty($formularParameters[$mandatoryField])
            || '0000-00-00' == $formularParameters[$mandatoryField]
        ) {
            $errors[$mandatoryField] = "{$emptyTranslation}";
            $this->context->smarty->assign('isBirthdateSet', false);
        }

        return $errors;
    }
}
