<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author        D3 Data Development
 * @support https://addons.prestashop.com/de/contact-us?id_product=21584
 */

namespace d3\heidelpay\ngw;

/**
 * Class Request
 *
 * @package d3\heidelpay\ngw
 */
class Request
{

    /**
     * @var string
     */
    protected $url = "";

    /**
     * @var int
     */
    protected $curlTimeOut = 30;

    /**
     * @var array
     */
    protected $data = array();

    /**
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @TODO: php league url object
     *
     * @param string $url
     */
    public function setUrl($url)
    {
        $this->url = $url;
    }

    /**
     * @return int
     */
    public function getCurlTimeOut()
    {
        return $this->curlTimeOut;
    }

    /**
     * @param int $curlTimeOut
     */
    public function setCurlTimeOut($curlTimeOut)
    {
        $this->curlTimeOut = $curlTimeOut;
    }

    /**
     * @return array
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * @TODO data valueobject
     *
     * @param $data
     */
    public function setData($data)
    {
        $this->data = $data;
    }
}
