<?php
namespace d3\heidelpay\payment\exception;

use Exception;

/**
 * Class PaymentNotReferencedToHeidelpayException
 */
class PaymentNotReferencedToHeidelpayException extends Exception
{
    /**
     * {@inheritdoc}
     * @param string  $sMessage exception message
     * @param integer $iCode    exception code
     */
    public function __construct($sMessage = "not set", $iCode = 0)
    {
        if ($sMessage == 'not set') {
            $sMessage = 'There is no heidelpay payment associated to the payment you provided!';
            $sMessage .= ' No further information was provided to better explain what went wrong.';
        } else {
            $sMessage = "There is no heidelpay payment associated to the payment you provided: '$sMessage'!";
        }

        parent::__construct($sMessage, $iCode);
    }
}
