<?php
namespace d3\heidelpay\request\exception;

use Exception;

/**
 * Class d3_d3heidelpay_models_request_exception_invalidtagnameException
 */
class InvalidTagNameException extends Exception
{
    /**
     * Set a default message for heidelpay exception
     *
     * @param string $sMessage
     * @param int    $iCode
     */
    public function __construct($sMessage = "not set", $iCode = 0)
    {
        if ($sMessage == 'not set') {
            $sMessage = 'You tried to generate an undefined xml tag!';
            $sMessage .= ' No further information was provided to better explain what went wrong.';
        } else {
            $sMessage = "You tried to generate an undefined xml tag: '$sMessage'!";
        }

        parent::__construct($sMessage, $iCode);
    }
}
