<?php
/**
 * NOTICE OF LICENSE
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    D3 Data Development
 * @copyright 2017 D3 Data Development
 * @license   LICENSE.txt
 */

require_once('HeidelpayBasketItemAbstractModel.php');

/**
 * Class HeidelpayBasketItemValueModel
 */
class HeidelpayBasketItemValueModel extends HeidelpayBasketItemAbstractModel
{
    public function __construct(array $productData, $position)
    {
        $this->position              = $position;
        $this->basketItemReferenceId = hash('sha512', serialize($productData));
        $this->unit                  = empty($productData['unity']) ? 'unit' : $productData['unity'];
        $this->quantity              = $productData['cart_quantity'];
        $this->amountDiscount        = $productData['price_without_reduction'] - $productData['price_with_reduction'];
        $this->vat                   = $productData['rate'];
        $this->amountPerUnit         = $productData['price_with_reduction'];
        $this->amountNet             = $productData['total'];
        $this->amountGross           = $productData['total_wt'];
        $this->amountVat             = $productData['total_wt'] - $productData['total'];
        $this->articleId             = $productData['reference'];
        $this->type                  = 'goods';
        $this->title                 = $productData['name'];
        $this->description           = $productData['description_short'];
        $this->imageUrl              = '';
    }
}
