<?php
/**
 * NOTICE OF LICENSE
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    D3 Data Development
 * @copyright 2017 D3 Data Development
 * @license   LICENSE.txt
 */

require_once('HeidelpayBasketItemAbstractModel.php');

/**
 * Class HeidelpayShippingValueModel
 */
class HeidelpayShippingValueModel extends HeidelpayBasketItemAbstractModel
{
    public function __construct(array $shippingData, $position)
    {
        $carrierList                 = $shippingData['carrier_list'];
        $carrier                     = current($carrierList);
        $this->position              = $position;
        $this->basketItemReferenceId = hash('sha512', serialize($shippingData));
        $this->unit                  = "";
        $this->quantity              = 1;
        $this->amountDiscount        = 0;
        $this->vat                   = $this->getVatValue(
            $shippingData['total_price_with_tax'],
            $shippingData['total_price_without_tax']
        );
        $this->amountPerUnit         = $shippingData['total_price_with_tax'];
        $this->amountNet             = $shippingData['total_price_without_tax'];
        $this->amountGross           = $shippingData['total_price_with_tax'];
        $this->amountVat             = $shippingData['total_price_with_tax'] - $shippingData['total_price_without_tax'];
        $this->articleId             = $carrier["instance"]->id_reference;
        $this->type                  = 'shipment';
        $this->title                 = $carrier["instance"]->name;
        $this->description           = '';
        $this->imageUrl              = '';
    }
}
