<?php
/**
 * NOTICE OF LICENSE
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    D3 Data Development
 * @copyright 2017 D3 Data Development
 * @license   LICENSE.txt
 */

include(_PS_MODULE_DIR_.'/heidelpay/libraries/vendor/autoload.php');
include_once(_PS_MODULE_DIR_.'/heidelpay/models/HeidelpayTransactionModel.php');
include_once(_PS_MODULE_DIR_.'/heidelpay/models/HeidelpayBasketValueModel.php');

/**
 * Class HeidelpayModuleFrontController
 */
class HeidelpayModuleFrontController extends ModuleFrontController
{
    /**
     *
     */
    const BLOFISH_KEY = 'BJGNGVEI6D78G68DFG8D74FG6DFGDGFGDFG654A6YXZTZ';
    /**
     *
     */
    const BLOFISH_VALUE = 'D6GF4GD466D48ER69R6ZIU4ZK46X6FV4G6ASF4H74GH8T';

    /**
     * @var bool
     */
    public $ssl = true;

    /**
     * @var bool
     */
    public $display_column_left = false;

    /**
     * @var bool
     */
    public $display_column_right = false;

    /**
     * @var string
     */
    public $currentTemplate = 'module:heidelpay/views/templates/front/errorpage.tpl';

    /**
     * @var string
     */
    public $page_name = 'checkout';

    /**
     * @throws PrestaShopException
     */
    public function initHeader()
    {
        $this->context->smarty->assign(array('errors' => array()));
        parent::initHeader();

        $this->setTemplate($this->currentTemplate);
    }

    /**
     * @throws PrestaShopException
     */
    public function initContent()
    {
        parent::initContent();
        $cart = $this->context->cart;
        if ($cart->nbProducts() <= 0) {
            $this->setErrorTemplate('Your shopping cart is empty');
        }
    }

    /**
     * @param      $processingReturnCode
     * @param bool $setTemplate
     *
     * @throws PrestaShopException
     */
    protected function setErrorTemplate($processingReturnCode, $setTemplate = true)
    {
        if ($setTemplate) {
            $this->setTemplate("module:heidelpay/views/templates/front/errorpage.tpl");
        }
        $translation = $this->module->getTranslator()->trans($processingReturnCode);
        if ($translation === $processingReturnCode) {
            $translation = $this->module->getTranslator()->trans(
                'An error occurred while processing payment code: '.$translation
            );
        }
        $this->context->smarty->assign(array('errors' => array($translation)));
    }

    /**
     * @param bool $returnJsonUrl
     *
     * @return string
     */
    public function getHeidelpayUrl($returnJsonUrl = false)
    {
        if (Configuration::get('HEIDELPAY_LIVE_MODE')) {
            if ($returnJsonUrl) {
                return 'https://heidelpay.hpcgw.net/ngw/basket';
            }

            return 'https://heidelpay.hpcgw.net/ngw/post';
        }

        if ($returnJsonUrl) {
            return 'https://test-heidelpay.hpcgw.net/ngw/basket';
        }

        return 'https://test-heidelpay.hpcgw.net/ngw/post';
    }

    /**
     * @return int
     */
    public function getHeidelpayCurlTimeOut()
    {
        return 30;
    }

    /**
     * @param $response
     *
     * @return mixed
     */
    public function getHeidelpayNgwBrands($response)
    {
        $sConfig_brands = $response['CONFIG_BRANDS'];
        if (get_magic_quotes_gpc()) {
            $sConfig_brands = Tools::stripslashes($sConfig_brands);
        }

        return json_decode($sConfig_brands, true);
    }

    /**
     * @param $parameter
     *
     * @return string
     */
    public function encode($parameter)
    {
        return json_encode($parameter);
    }

    /**
     * @param $parameter
     *
     * @return mixed
     */
    public function decode($parameter)
    {
        return json_decode($parameter, true);
    }

    /**
     * @param $data
     *
     * @return string
     */
    public function generateHash($data)
    {
        $stringToHash = Configuration::get('HEIDELPAY_SECRET', null);
        $hashIndexes  = array(
            'CRITERION.SESSION',
            'IDENTIFICATION.TRANSACTIONID',
            'PRESENTATION.AMOUNT',
            'PRESENTATION.CURRENCY',
            'TRANSACTION.CHANNEL',
        );

        foreach ($hashIndexes as $hashIndex) {
            if (isset($data[$hashIndex])) {
                $stringToHash .= $data[$hashIndex];
            }
        }

        $ascii = bin2hex($stringToHash);
        $hash  = sha1($ascii);

        PrestaShopLogger::addLog(
            __CLASS__.'::hash:'.$hash.'::stringToHash:'.$stringToHash,
            1,
            null,
            'Unzer Module',
            null,
            true
        );

        return $hash;
    }

    /**
     * @param $response
     *
     * @return bool
     */
    public function isHashValid($response)
    {
        if (false == isset($response['CRITERION_HASH'])) {
            return false;
        }
        $sOriginalHash = $response['CRITERION_HASH'];

        $stringToHash = Configuration::get('HEIDELPAY_SECRET', null);

        $hashIndexes = array(
            'CRITERION_SESSION',
            'IDENTIFICATION_TRANSACTIONID',
            'PRESENTATION_AMOUNT',
            'PRESENTATION_CURRENCY',
            'TRANSACTION_CHANNEL',
        );

        foreach ($hashIndexes as $hashIndex) {
            if (isset($response[$hashIndex])) {
                $stringToHash .= $response[$hashIndex];
            }
        }

        $ascii      = bin2hex($stringToHash);
        $sCheckHash = sha1($ascii);

        PrestaShopLogger::addLog(__CLASS__.'::stringToHash:'.$stringToHash. //
            '::sCheckHash:'.$sCheckHash.'::$sOriginalHash:'.$sOriginalHash, 1, null, 'Unzer Module', null, true);

        return $sCheckHash === $sOriginalHash;
    }

    /**
     * @param array $formularParameters
     *
     * @return array
     */
    public function validateCustomerData(array $formularParameters)
    {
        $mandatoryFields = array(
            'NAME.GIVEN',
            'NAME.FAMILY',
            'ADDRESS.STREET',
            'ADDRESS.ZIP',
            'ADDRESS.CITY',
            'ADDRESS.COUNTRY',
            'CONTACT.EMAIL',
        );

        $errors            = array();
        $notSetTranslation = $this->module->l('is not set, but mandatory!');
        $emptyTranslation  = $this->module->l('is set, but empty!');
        foreach ($mandatoryFields as $mandatoryField) {
            if (false == isset($formularParameters[$mandatoryField])) {
                $errors[$mandatoryField] = "{$mandatoryField} $notSetTranslation";
                continue;
            }
            if (empty($formularParameters[$mandatoryField])) {
                $errors[$mandatoryField] = "{$mandatoryField} $emptyTranslation";
                continue;
            }
        }

        return $errors;
    }
}
