<?php
namespace d3\heidelpay;

use SimpleXMLElement;

/**
 * Class response
 */
class Response
{
    public $StatusCode;

    public $ReasonCode;

    public $Result;

    public $Redirect;

    public $RedirectURL;

    public $aRedirectParameter;

    public $Reason;

    public $Return;

    public $ReturnCode;

    public $ShortID;

    public $UniqueID;

    public $TransID;

    /** @var  string */
    protected $responseData;

    /** @var  int */
    protected $errorNo;

    /** @var  string */
    protected $error;

    /**
     * Class constructor, sets properties: oModCfg, mData, iErrorNo, sError
     *
     * @param            $responseData
     * @param            $errorNo
     * @param            $error
     */
    public function __construct($responseData, $errorNo, $error)
    {
        $this->responseData = $responseData;
        $this->errorNo      = $errorNo;
        $this->error        = $error;

        $this->parseResponseData($this->responseData);
    }

    /**
     * parses response data and set properties
     *
     * @uses d3_d3heidelpay_models_response::parseFrontendParameter
     *
     * @param string $sData
     */
    protected function parseResponseData($sData)
    {
        $xmlDom = simplexml_load_string($sData);

        //$Status	= (string)$obj_xml->Transaction->Processing->Status;
        if ($xmlDom->Transaction->Processing->Status) {
            $this->StatusCode = (string)$xmlDom->Transaction->Processing->Status->getAttribute('code');
        }
        if ($xmlDom->Transaction->Processing->Reason) {
            $this->ReasonCode = (string)$xmlDom->Transaction->Processing->Reason->getAttribute('code');
        }
        $this->Result = (string)$xmlDom->Transaction->Processing->Result;

        $this->parseFrontendParameter($xmlDom);

        $this->Reason = (string)$xmlDom->Transaction->Processing->Reason;
        $this->Result = (string)$xmlDom->Transaction->Processing->Result;
        $this->Return = (string)$xmlDom->Transaction->Processing->Return;
        if ($xmlDom->Transaction->Processing->Return) {
            $this->ReturnCode = (string)$xmlDom->Transaction->Processing->Return->getAttribute('code');
        }
        $this->ShortID  = (string)$xmlDom->Transaction->Identification->ShortID;
        $this->UniqueID = (string)$xmlDom->Transaction->Identification->UniqueID;
        $this->TransID  = (string)$xmlDom->Transaction->Identification->TransactionID;
    }

    /**
     * parses and prepare redirectparameter for frontend only
     *
     * @param SimpleXMLElement $xmlDom
     */
    protected function parseFrontendParameter(SimpleXMLElement $xmlDom)
    {
        if ($xmlDom->Transaction->Processing->Redirect) {
            $this->RedirectURL = (string)$xmlDom->Transaction->Processing->Redirect->getAttribute('url');
        }

        $this->setRedirectParameter($xmlDom);
    }

    /**
     * set redirect properties
     *
     * @param SimpleXMLElement $xmlDom
     */
    protected function setRedirectParameter(SimpleXMLElement $xmlDom)
    {
        $this->Redirect           = $xmlDom->Transaction->Processing->Redirect;
        $this->aRedirectParameter = array();

        if (isset($this->Redirect->Parameter)) {
            /** @var SimpleXMLElement $val */
            foreach ($this->Redirect->Parameter as $val) {
                $this->aRedirectParameter[(string)$val->attributes()->{'name'}] = (string)$val;
            }
        }
    }

    /**
     * Returns property mData
     *
     * @return string
     */
    public function getData()
    {
        return $this->responseData;
    }

    /**
     * Returns property sError
     *
     * @return string
     */
    public function getError()
    {
        return $this->error;
    }

    /**
     * Returns property iErrorNo
     *
     * @return int
     */
    public function getErrorNo()
    {
        return $this->errorNo;
    }
}
