<?php
namespace d3\heidelpay\payment;

use d3\heidelpay\redirect;
use d3\heidelpay\request\pattern\OnlineTransfer;
use d3\heidelpay\response\Parser;
use ReflectionException;

/**
 * Class d3_d3heidelpay_models_payment_przelewy24
 */
class Przelewy24 extends AbstractPayment
{
    /**
     * {@inheritdoc}
     */
    public function getRequestXmlPattern()
    {
        return new OnlineTransfer();
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentCode()
    {
        return 'OT';
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentTypes()
    {
        return array('PA', 'RC', 'RF');
    }

    /**
     * Returns empty array
     *
     * @param Parser $oParser
     *
     * @return array
     */
    public function getDynamicValues(Parser $oParser)
    {
        return array();
    }

    /**
     * @return redirect
     * @throws ReflectionException
     * @throws exception\UnknownRedirectParameterException
     */
    public function getRedirect()
    {
        return new redirect(redirect::REDIRECT_TYPE_POST);
    }
}
