<?php
namespace d3\heidelpay\payment\exception;

use Exception;

/**
 * Class UnknownRedirectParameterException
 */
class UnknownRedirectParameterException extends Exception
{
    /**
     * {@inheritdoc}
     * @param string  $sMessage exception message
     * @param integer $iCode    exception code
     */
    public function __construct($sMessage = "", $iCode = 0)
    {
        $sCompleteMessage = "There is an unknown redirect parameter given: '$sMessage'!";
        if (empty($sMessage)) {
            $sCompleteMessage = 'There is an empty redirect parameter given. Please use constants of redirect.';
        }

        parent::__construct($sCompleteMessage, $iCode);
    }
}
