<?php
namespace d3\heidelpay\payment\invoice;

use d3\heidelpay\payment\AbstractPayment;
use d3\heidelpay\payment\exception\UnknownRedirectParameterException;
use d3\heidelpay\response\Parser;
use d3\heidelpay\request\pattern\PrePayment;
use d3\heidelpay\Redirect;
use ReflectionException;

/**
 * Class Unsecured
 */
class Unsecured extends AbstractPayment
{
    /**
     * {@inheritdoc}
     */
    public function getRequestXmlPattern()
    {
        return new PrePayment();
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentCode()
    {
        return 'IV';
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentTypes()
    {
        return array('PA', 'RC', 'RF');
    }

    /**
     * Returns empty array
     *
     * @param Parser $oParser
     *
     * @return array
     */
    public function getDynamicValues(Parser $oParser)
    {
        return array();
    }

    /**
     * @return Redirect
     * @throws ReflectionException
     * @throws UnknownRedirectParameterException
     */
    public function getRedirect()
    {
        return new Redirect();
    }
}
