{*
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    D3 Data Development
*  @copyright 2017 D3 Data Development
*  @license   LICENSE.txt
*}
{extends file='checkout/checkout.tpl'}
{block name="content"}
    <section id="content">
        <div class="row">
            <div class="col-md-12">
                <section id="checkout-payment-step" class="checkout-step -current -reachable js-current-step">
                    <h1 class="text-xs-center">{l s='Payment' mod='heidelpay'}</h1>

                    <h2 class="text-xs-center">{l s='assuredinvoice_title' mod='heidelpay'}</h2>

                    {include file="module:heidelpay/views/templates/front/error.tpl"}

                    <form action="{$formularUrl}" method="post">
                        <div class="row" id="d3HeidelpayPaymentContainer">
                            <div class="col-md-10 offset-md-2">
                                <table width="100%">
                                    <tr>
                                        <th colspan="2">{l s='assuredinvoice_fill_out_fields' mod='heidelpay'}</th>
                                    </tr>
                                    {if empty($fields)}
                                        <tr>
                                            <td colspan="2">
                                                error
                                            </td>
                                        </tr>
                                    {else}
                                        {foreach from=$fields item="fieldTranslation" key="fieldName"}
                                        <tr>
                                            <td>
                                                <label for="d3{$fieldName}">{$fieldTranslation}</label>
                                            </td>
                                            <td>
                                                <input id="d3{$fieldName}" type="{if $fieldName == 'NAME.BIRTHDATE'}date{else}text{/if}" name="{$fieldName}" />

                                            </td>
                                        </tr>
                                        {/foreach}
                                    {/if}
                                </table>
                            </div>
                        </div>
                        <a href="{$link->getPageLink('order', true, NULL, "step=3")}"
                           class="btn btn-default">
                            {l s='Other payment methods' mod='heidelpay'}
                        </a>
                        <button type="submit" id="heidelpayPayNowButton"
                                class="btn btn-primary center-block pull-md-right">
                            {l s='pay now' mod='heidelpay'}
                        </button>
                    </form>
                </section>
            </div>
        </div>
    </section>
{/block}
