<?php

namespace d3\heidelpay\actions;

/**
 * Class Refund
 */
class Refund extends AbstractAction
{
    protected $value = 'RF';

    protected $title = 'Refund (REF)';

    /**
     * @return bool
     */
    public function isDisabled()
    {
        $paymentCode = $this->getPaymentCode();

        return false == (
            $paymentCode == 'CC.DB'
            || $paymentCode == 'CC.CP'
            || $paymentCode == 'CC.RB'
            || $paymentCode == 'DC.DB'
            || $paymentCode == 'DC.CP'
            || $paymentCode == 'DC.RB'
            || $paymentCode == 'DD.DB'
            || $paymentCode == 'DD.RB'
            || $paymentCode == 'OT.RC'
            || $paymentCode == 'VA.DB'
            );
    }
}
